/*
 * Decompiled with CFR 0.152.
 */
package ca.kylecharters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;

public class Cylinder
extends JComponent {
    private static final long serialVersionUID = 42424242L;
    private int width;
    private int depth;
    private int height;
    private Color topColor;
    private Color sideColor;

    public Cylinder(int width, int depth, int height, Color topColor, Color sideColor) {
        this.width = width;
        this.depth = depth;
        this.height = height;
        this.topColor = topColor;
        this.sideColor = sideColor;
        this.setSize(new Dimension(width, height + depth));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height + this.depth);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.sideColor);
        g2d.fill(new Ellipse2D.Double(0.0, this.height, this.width, this.depth));
        g2d.fill(new Rectangle(0, this.depth / 2, this.width, this.height));
        g2d.setColor(this.topColor);
        g2d.fill(new Ellipse2D.Double(0.0, 0.0, this.width, this.depth));
    }
}

